import os
import pandas as pd
import numpy as np

# Define folder paths
input_folder =r'D:/***'  # Replace with the path to the folder containing CSV files
output_folder_B = r'D:/***'  # Replace with the path for output folder B
output_folder_C = r'D:/***'  # Replace with the path for output folder C


# Create output folders if they don't exist
os.makedirs(output_folder_B, exist_ok=True)
os.makedirs(output_folder_C, exist_ok=True)

# Get all CSV files in the folder
csv_files = [f for f in os.listdir(input_folder) if f.endswith('.csv')]

for file in csv_files:
    # Read CSV file
    file_path = os.path.join(input_folder, file)
    data = pd.read_csv(file_path, header=None)

    # Shuffle data
    data_shuffled = data.sample(frac=1, random_state=73).reset_index(drop=True)

    # Split data in 8:2 ratio
    split_index = int(len(data_shuffled) * 0.8)
    data_B = data_shuffled[:split_index]
    data_C = data_shuffled[split_index:]

    # Save to folders B and C
    output_path_B = os.path.join(output_folder_B, file)
    output_path_C = os.path.join(output_folder_C, file)

    data_B.to_csv(output_path_B, index=False, header=False)
    data_C.to_csv(output_path_C, index=False, header=False)

print("Data has been successfully split in 8:2 ratio and saved to corresponding folders.")
